/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2008 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.vo;

import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.vo.MosPVo;

import jp.mosp.kintai.dto.MYukyuDto;

public class YukyuPersonalCardVo extends MosPVo {

	private static final long serialVersionUID = 4422751719733412912L;

	// URL
	private static final String RETURN_URL = "/jsp/payroll/yukyuPersonalCard.jsp";
	private static final String EXTRA_JS   = "/pub/payroll/js/yukyuPersonalCard.js";
	private static final String EXTRA_CSS  = "/pub/payroll/css/yukyuPersonalCard.css";

	// ʃTu^Cg
	public final String SUB_TITLE = CommonConst.TTL_PAID_HOLIDAY;

	public final String CMD_PAID_HOLIDAY_SEARCH 		= "P1110";
	public final String TTL_PAID_HOLIDAY 				= CommonConst.TTL_EMPLOYEE_YUKYU_SELECT;

	// 萔
	public static final int MODE_VIEW		= 0;
	public static final int MODE_UPDATE	= 1;

	// p[^
	public static final String PRM_SELECT_K_CODE 			= "selectKCode"			;
	public static final String PRM_HID_THIS_REST_TOTAL 	= "hidThisRestTotal"	;//civj
	public static final String PRM_HID_THIS_REST_TY 		= "hidThisRestTY"		;//ciNj
	public static final String PRM_HID_THIS_REST_LY 		= "hidThisRestLY"		;//ciONj
	public static final String PRM_HID_GET 				= "hidGet"				;//擾
	public static final String PRM_HID_DISPOSE 			= "hidDispose"			;//p
	public static final String PRM_LBL_CALC_YEAR 			= "lblCalcYear"			;//^vZN
	public static final String PRM_LBL_CALC_MONTH 		= "lblCalcMonth"		;//^vZ
	public static final String PRM_LBL_THIS_REST_TOTAL 	= "lblThisRestTotal"	;//civj
	public static final String PRM_LBL_THIS_REST_TY 		= "lblThisRestTY"		;//ciNj
	public static final String PRM_LBL_THIS_REST_LY 		= "lblThisRestLY"		;//ciONj
	public static final String PRM_TXT_THIS_GET_TY 		= "txtThisGetTY"		;//擾iNj
	public static final String PRM_TXT_THIS_GET_LY 		= "txtThisGetLY"		;//擾iONj
	public static final String PRM_TXT_THIS_DISPOSE_TY 	= "txtThisDisposeTY"	;//piNj
	public static final String PRM_TXT_THIS_DISPOSE_LY  	= "txtThisDisposeLY"	;//piONj
	public static final String PRM_TXT_THIS_REST_TOTAL 	= "txtThisRestTotal"	;//civj
	public static final String PRM_TXT_THIS_REST_TY 		= "txtThisRestTY"		;//ciNj
	public static final String PRM_TXT_THIS_REST_LY 		= "txtThisRestLY"		;//ciONj

	// tB[h
	private String selectKCode;
	private String selectKName;
	private String selectSectionName;
	private String hidThisRestTotal;
	private String hidThisRestTY;
	private String hidThisRestLY;
	private String hidGet;
	private String hidDispose;
	private String lblCalcYear;
	private String lblCalcMonth;
	private String lblThisRestTotal;
	private String lblThisRestTY;
	private String lblThisRestLY;
	private String txtThisGetTY;
	private String txtThisGetLY;
	private String txtThisDisposeTY;
	private String txtThisDisposeLY;
	private String txtThisRestTotal;
	private String txtThisRestTY;
	private String txtThisRestLY;
	private String[] aryCalcYear;
	private String[] aryCalcMonth;
	private String[] aryGet;
	private String[] aryDispose;
	private String[] aryThisRestTY;
	private String[] aryThisRestLY;
	private String[] aryUse;

	// [h(1FXV)
	private int mode;

	// tB[hyѐ
	public static final String NAM_K_CODE 				= CommonConst.NAM_K_CODE	;
	public static final String NAM_K_NAME					= CommonConst.NAM_K_NAME	;
	public static final String NAM_STATION				= CommonConst.NAM_STATION	;

	public static final String NAM_CALC_DATE				= CommonConst.NAM_PAY_CALCULATE + CommonConst.NAM_MONTH		;
	public static final String NAM_THIS_GET				= CommonConst.NAM_GET										;
	public static final String NAM_THIS_GET_THIS			= CommonConst.NAM_GET + CommonConst.NAM_YEAR_THIS			;
	public static final String NAM_THIS_GET_FORMER		= CommonConst.NAM_GET + CommonConst.NAM_YEAR_FORMER			;
	public static final String NAM_THIS_DISPOSE			= CommonConst.NAM_DISPOSE									;
	public static final String NAM_THIS_DISPOSE_THIS		= CommonConst.NAM_DISPOSE + CommonConst.NAM_YEAR_THIS		;
	public static final String NAM_THIS_DISPOSE_FORMER	= CommonConst.NAM_DISPOSE + CommonConst.NAM_YEAR_FORMER		;
	public static final String NAM_REST					= CommonConst.NAM_ABB_PAID_HOLIDAY + CommonConst.NAM_AMOUNT	;
	public static final String NAM_USE 					= CommonConst.NAM_USE										;
	public static final String NAM_THIS_MONTH				= CommonConst.NAM_MONTH_THIS								;
	public static final String NAM_LAST_MONTH 			= CommonConst.NAM_MONTH_FORMER								;
	public static final String NAM_THIS_YEAR 				= CommonConst.NAM_YEAR_THIS									;
	public static final String NAM_LAST_YEAR 				= CommonConst.NAM_YEAR_FORMER								;
	public static final String NAM_TOTAL					= CommonConst.NAM_COMMON_SUM 								;

	public static final int	LEN_PAID_HOLIDAY 		= 5;
	public static final int	LEN_INTEGER 			= 2;
	public static final int	LEN_DECIMAL 			= 1;

	/**
	 * RXgN^
	 */
	public YukyuPersonalCardVo() {
		super();
		mode = 0;
		setExtraCss(EXTRA_CSS);
		addExtraJs(EXTRA_JS);
		setRetUrl(RETURN_URL);
		aryCalcYear   	= new String[0];
		aryCalcMonth   	= new String[0];
		aryGet			= new String[0];
		aryDispose  	= new String[0];
		aryThisRestTY   = new String[0];
		aryThisRestLY   = new String[0];
		aryUse     		= new String[0];
	}

	/**
	 * lݒ
	 */	
	public void setDefaultValues(){
		setSelectKName		("0");
		setSelectSectionName("0");
		setHidThisRestToTal	("0");
		setHidThisRestTY	("0");
		setHidThisRestLY	("0");
		setHidGet			("0");
		setHidDispose		("0.0");
		setLblCalcYear		(""	);
		setLblCalcMonth		(""	);
		setLblThisRestTotal	("0");
		setLblThisRestTY	("0");
		setLblThisRestLY	("0");
		setTxtThisGetTY		("0");
		setTxtThisGetLY		("0");
		setTxtThisDisposeTY	("0.0");
		setTxtThisDisposeLY	("0.0");
		setTxtThisRestToTal	("0");
		setTxtThisRestTY	("0");
		setTxtThisRestLY	("0");
	}

	/**
	 * p[^ݒ
	 */
	public void setParams(HttpServletRequest request) {
		selectKCode	 		=  request.getParameter(PRM_SELECT_K_CODE 		);
		hidThisRestTotal	=  request.getParameter(PRM_HID_THIS_REST_TOTAL );
		hidThisRestTY	 	=  request.getParameter(PRM_HID_THIS_REST_TY 	);
		hidThisRestLY	 	=  request.getParameter(PRM_HID_THIS_REST_LY 	);
		hidGet	 			=  request.getParameter(PRM_HID_GET 			);
		hidDispose	 		=  request.getParameter(PRM_HID_DISPOSE 		);
		lblCalcYear	 		=  request.getParameter(PRM_LBL_CALC_YEAR 		);
		lblCalcMonth	 	=  request.getParameter(PRM_LBL_CALC_MONTH 		);
		lblThisRestTotal	=  request.getParameter(PRM_LBL_THIS_REST_TOTAL );
		lblThisRestTY	 	=  request.getParameter(PRM_LBL_THIS_REST_TY 	);
		lblThisRestLY	 	=  request.getParameter(PRM_LBL_THIS_REST_LY 	);
		txtThisGetTY	 	=  request.getParameter(PRM_TXT_THIS_GET_TY 	);
		txtThisGetLY	 	=  request.getParameter(PRM_TXT_THIS_GET_LY 	);
		txtThisDisposeTY	=  request.getParameter(PRM_TXT_THIS_DISPOSE_TY );
		txtThisDisposeLY	=  request.getParameter(PRM_TXT_THIS_DISPOSE_LY );
		txtThisRestTotal	=  request.getParameter(PRM_TXT_THIS_REST_TOTAL );
		txtThisRestTY	 	=  request.getParameter(PRM_TXT_THIS_REST_TY 	);
		txtThisRestLY	 	=  request.getParameter(PRM_TXT_THIS_REST_LY 	);
	}

	/**
	 * tB[hݒ
	 * @param dto 
	 */
	public void setFields(MYukyuDto dto) {
		lblCalcYear 		= util.convIntegerDateToArray(dto.getKyuyoYMD())[0];
		lblCalcMonth 		= util.convIntegerDateToArray(dto.getKyuyoYMD())[1];
		hidThisRestTY 		= String.valueOf(dto.getTZanT());
		hidThisRestLY 		= String.valueOf(dto.getTZanZ());
		hidThisRestTotal 	= String.valueOf(dto.getTZanT() + dto.getTZanZ());
		hidGet 				= String.valueOf(dto.getSyutoku());
		hidDispose 			= String.valueOf(dto.getHaiki());
		lblThisRestTY 		= hidThisRestTY;
		lblThisRestLY 		= hidThisRestLY;
		lblThisRestTotal 	= hidThisRestTotal;
		txtThisRestTY 		= hidThisRestTY;
		txtThisRestLY 		= hidThisRestLY;
		txtThisRestTotal 	= hidThisRestTotal;
	}

	/**
	 * tB[hݒ
	 * @param list
	 * @throws MospException
	 */
	public void setFields(List list) {
		// Xg̐ݒ
		this.list = list;
		// f[^̎擾
		count = list.size();
		// z̏
		aryCalcYear  	= new String[count];
		aryCalcMonth 	= new String[count];
		aryGet			= new String[count];
		aryDispose  	= new String[count];
		aryThisRestTY   = new String[count];
		aryThisRestLY   = new String[count];
		aryUse     		= new String[count];
		// f[^̐ݒ
		int i = 0;
		Iterator it = list.iterator();
		while (it.hasNext()) {
			MYukyuDto dto = (MYukyuDto)it.next();
			aryCalcYear[i]		= escapeHTML(util.convIntegerDateToArray(dto.getKyuyoYMD())[0]);
			aryCalcMonth[i]		= escapeHTML(util.convIntegerDateToArray(dto.getKyuyoYMD())[1]);
			aryGet[i]			= escapeHTML(String.valueOf(dto.getSyutoku()));
			aryDispose[i]  		= escapeHTML(String.valueOf(dto.getHaiki()));
			aryThisRestTY[i]	= escapeHTML(String.valueOf(dto.getTZanT()));
			aryThisRestLY[i]	= escapeHTML(String.valueOf(dto.getTZanZ()));
			aryUse[i]			= escapeHTML(String.valueOf(dto.getSyoka()));
			i++;
		}
	}

	/**
	 * tB[hݒ(DTOɑ΂VÕZbg)
	 * @param dto ݒΏDTO
	 * insertp
	 */
	public void setDtoFields(MYukyuDto dto, String date) {
		dto.setKCode(selectKCode);
		dto.setKyuyoYMD(Integer.parseInt(date));
		dto.setSyutoku(Integer.parseInt(hidGet));
		dto.setHaiki(Double.parseDouble(hidDispose));
		dto.setTZanT(Double.parseDouble(hidThisRestTY));
		dto.setTZanZ(Double.parseDouble(hidThisRestLY));
	}

	/**
	 * tB[hݒ(DTOɑ΂VÕZbg)
	 * @param dto ݒΏDTO
	 * updatep
	 */
	public void setDtoFields(MYukyuDto dto) {
		dto.setSyutoku(Integer.parseInt(hidGet));
		dto.setHaiki(Double.parseDouble(hidDispose));
		dto.setTZanT(Double.parseDouble(hidThisRestTY));
		dto.setTZanZ(Double.parseDouble(hidThisRestLY));
	}

	/**
	 * tB[h̑ÓmF
	 * @throws MospException
	 */
	public void validate() throws MospException {
		// ÓmFJn
		startValidation();
		// K{mF
		checkRequired(txtThisGetTY		, NAM_THIS_GET_THIS			, PRM_TXT_THIS_GET_TY		);
		checkRequired(txtThisGetLY		, NAM_THIS_GET_FORMER		, PRM_TXT_THIS_GET_LY		);
		checkRequired(txtThisDisposeTY	, NAM_THIS_DISPOSE_THIS		, PRM_TXT_THIS_DISPOSE_TY	);
		checkRequired(txtThisDisposeLY	, NAM_THIS_DISPOSE_FORMER 	, PRM_TXT_THIS_DISPOSE_LY	);
		// mF
		checkNumber(txtThisGetTY		, NAM_THIS_GET_THIS			, PRM_TXT_THIS_GET_TY		);
		checkNumber(txtThisGetLY		, NAM_THIS_GET_FORMER		, PRM_TXT_THIS_GET_LY		);
		checkNumeric(txtThisDisposeTY	, NAM_THIS_DISPOSE_THIS		, PRM_TXT_THIS_DISPOSE_TY	);
		checkNumeric(txtThisDisposeLY	, NAM_THIS_DISPOSE_FORMER	, PRM_TXT_THIS_DISPOSE_LY	);
		// mF	
		checkLength(txtThisGetTY		, LEN_PAID_HOLIDAY	, NAM_THIS_GET_THIS			, PRM_TXT_THIS_GET_TY		);
		checkLength(txtThisGetLY		, LEN_PAID_HOLIDAY	, NAM_THIS_GET_FORMER		, PRM_TXT_THIS_GET_LY		);
		checkLength(txtThisDisposeTY	, LEN_PAID_HOLIDAY	, NAM_THIS_DISPOSE_THIS		, PRM_TXT_THIS_DISPOSE_TY	);
		checkLength(txtThisDisposeLY	, LEN_PAID_HOLIDAY	, NAM_THIS_DISPOSE_FORMER	, PRM_TXT_THIS_DISPOSE_LY	);
		// ÓmFI
		endValidation();
	}

	/**
	 * JavaScriptݒ
	 * @param cls 擾NX
	 * @throws IllegalAccessException
	 */
	@Override
	public String getDirectJs(Class cls) throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append(super.getDirectJs(cls));
		sb.append("var MODE = ");
		sb.append(mode);
		sb.append(";");
		return sb.toString();
	}

	// ANZT\bh	
	public String[] getEscAryCalcYear		() { return aryCalcYear.clone()		; }
	public String[] getEscAryCalcMonth		() { return aryCalcMonth.clone()	; }
	public String[] getEscAryGet			() { return aryGet.clone()			; }
	public String[] getEscAryDispose		() { return aryDispose.clone()		; }
	public String[] getEscAryThisRestTY		() { return aryThisRestTY.clone()	; }
	public String[] getEscAryThisRestLY		() { return aryThisRestLY.clone()	; }
	public String[] getEscAryUse			() { return aryUse.clone()			; }

	public String getSelectKCode		() { return	 selectKCode		; }
	public String getSelectKName       	() { return	 selectKName        ; }
	public String getSelectSectionName	() { return	 selectSectionName  ; }
	public String getHidThisRestToTal	() { return	 hidThisRestTotal	; }
	public String getHidThisRestTY		() { return	 hidThisRestTY		; }
	public String getHidThisRestLY		() { return	 hidThisRestLY		; }
	public String getHidTGet			() { return hidGet				; }
	public String getHidDispose			() { return hidDispose			; }
	public String getLblCalcYear		() { return	 lblCalcYear		; }
	public String getLblCalcMonth		() { return	 lblCalcMonth		; }
	public String getLblThisRestTotal	() { return	 lblThisRestTotal	; }
	public String getLblThisRestTY		() { return	 lblThisRestTY		; }
	public String getLblThisRestLY		() { return	 lblThisRestLY		; }
	public String getTxtThisGetTY		() { return	 txtThisGetTY		; }
	public String getTxtThisGetLY		() { return	 txtThisGetLY		; }
	public String getTxtThisDisposeTY	() { return	 txtThisDisposeTY	; }
	public String getTxtThisDisposeLY	() { return	 txtThisDisposeLY	; }
	public String getTxtThisRestToTal	() { return	 txtThisRestTotal	; }
	public String getTxtThisRestTY		() { return	 txtThisRestTY		; }
	public String getTxtThisRestLY		() { return	 txtThisRestLY		; }

	public String getEscSelectKCode      	() { return escapeHTML(	 selectKCode		); }
	public String getEscSelectKName      	() { return escapeHTML(	 selectKName 		); }
	public String getEscSelectSectionName	() { return escapeHTML(	 selectSectionName	); }	
	public String getEscHidThisRestToTal	() { return escapeHTML(	 hidThisRestTotal	); }
	public String getEscHidThisRestTY		() { return escapeHTML(	 hidThisRestTY		); }
	public String getEscHidThisRestLY		() { return escapeHTML(	 hidThisRestLY		); }
	public String getEscHidTGet				() { return escapeHTML(	 hidGet				); }
	public String getEscHidDispose			() { return escapeHTML(	 hidDispose			); }
	public String getEscLblCalcYear			() { return escapeHTML(	 lblCalcYear		); }
	public String getEscLblCalcMonth		() { return escapeHTML(	 lblCalcMonth		); }
	public String getEscLblThisRestTotal	() { return escapeHTML(	 lblThisRestTotal	); }
	public String getEscLblThisRestTY		() { return escapeHTML(	 lblThisRestTY		); }
	public String getEscLblThisRestLY		() { return escapeHTML(	 lblThisRestLY		); }
	public String getEscTxtThisGetTY		() { return escapeHTML(	 txtThisGetTY		); }
	public String getEscTxtThisGetLY		() { return escapeHTML(	 txtThisGetLY		); }
	public String getEscTxtThisDisposeTY	() { return escapeHTML(	 txtThisDisposeTY	); }
	public String getEscTxtThisDisposeLY	() { return escapeHTML(	 txtThisDisposeLY	); }
	public String getEscTxtThisRestToTal	() { return escapeHTML(	 txtThisRestTotal	); }
	public String getEscTxtThisRestTY		() { return escapeHTML(	 txtThisRestTY		); }
	public String getEscTxtThisRestLY		() { return escapeHTML(	 txtThisRestLY		); }

	public void setSelectKCode      	(String	selectKCode     	) { this.selectKCode       	= 	selectKCode      	; }
	public void setSelectKName      	(String selectKName     	) { this.selectKName       	= 	selectKName      	; }
	public void setSelectSectionName	(String selectSectionName	) { this.selectSectionName 	= 	selectSectionName	; }
	public void setHidThisRestToTal	(String	hidThisRestTotal	) { this.hidThisRestTotal	= 	hidThisRestTotal	; }
	public void setHidThisRestTY		(String	hidThisRestTY		) { this.hidThisRestTY	  	=	hidThisRestTY		; }
	public void setHidGet				(String	hidGet				) { this.hidGet				= 	hidGet				; }
	public void setHidDispose			(String	hidDispose			) { this.hidDispose	  		=	hidDispose			; }
	public void setHidThisRestLY		(String	hidThisRestLY		) { this.hidThisRestLY	  	=	hidThisRestLY		; }
	public void setLblCalcYear			(String	lblCalcYear			) { this.lblCalcYear	  	=	lblCalcYear			; }
	public void setLblCalcMonth		(String	lblCalcMonth		) { this.lblCalcMonth	  	=	lblCalcMonth		; }
	public void setLblThisRestTotal	(String	lblThisRestTotal	) { this.lblThisRestTotal	=	lblThisRestTotal	; }
	public void setLblThisRestTY		(String	lblThisRestTY		) { this.lblThisRestTY	  	=	lblThisRestTY		; }
	public void setLblThisRestLY		(String	lblThisRestLY		) { this.lblThisRestLY	  	=	lblThisRestLY		; }
	public void setTxtThisGetTY		(String	txtThisGetTY		) { this.txtThisGetTY	  	=	txtThisGetTY		; }
	public void setTxtThisGetLY		(String	txtThisGetLY		) { this.txtThisGetLY	  	=	txtThisGetLY		; }
	public void setTxtThisDisposeTY	(String	txtThisDisposeTY	) { this.txtThisDisposeTY  	=	txtThisDisposeTY	; }
	public void setTxtThisDisposeLY	(String	txtThisDisposeLY	) { this.txtThisDisposeLY	=	txtThisDisposeLY	; }
	public void setTxtThisRestToTal	(String	txtThisRestTotal	) { this.txtThisRestTotal	=	txtThisRestTotal	; }
	public void setTxtThisRestTY		(String	txtThisRestTY		) { this.txtThisRestTY	  	=	txtThisRestTY		; }
	public void setTxtThisRestLY		(String	txtThisRestLY		) { this.txtThisRestLY	  	=	txtThisRestLY		; }

	public void setMode(int mode) { this.mode = mode; }
	public int getMode() { return mode; }

}
